VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SampleIndexRegistrations"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"No"
Attribute VB_Ext_KEY = "Collection" ,"SampleIndexRegistration"
Attribute VB_Ext_KEY = "Member0" ,"SampleIndexRegistration"
'locsal variable to hold collection
Private mCol As Collection
Private SampleHolderIndex As SampleIndexRegistration

Const SampleHolderIndexTag = "!Holder"

Public Function Add(filedir As String, FileName As String, BackupFileDir As String, SampleCode As String, Optional avgSteps As Integer = 1, _
    Optional doUp As Boolean = True, Optional doBoth As Boolean = True, Optional measurementSteps As RockmagSteps, Optional ByVal RockmagMode As Boolean = False) As SampleIndexRegistration
    'create a new object
    Dim objNewMember As SampleIndexRegistration
    Set objNewMember = New SampleIndexRegistration


    'set the properties passed into the method
    objNewMember.filedir = filedir
    objNewMember.FileName = FileName
    objNewMember.BackupFileDir = BackupFileDir
    objNewMember.SampleCode = SampleCode
    objNewMember.avgSteps = avgSteps
    objNewMember.doUp = doUp
    objNewMember.doBoth = doBoth
    objNewMember.RockmagMode = RockmagMode
    Set objNewMember.measurementSteps = measurementSteps
    
    objNewMember.loadInfo
    
    mCol.Add objNewMember, FileName

    'return the object created
    Set Add = objNewMember
    Set objNewMember = Nothing


End Function

Public Function AddSampleIndex(SampleIndex As SampleIndexRegistration) As SampleIndexRegistration
    
    On Error GoTo Oops
    
    With SampleIndex
        If LenB(Item(.FileName).FileName) > 0 Then Remove .FileName
        Set AddSampleIndex = Add(.filedir, .FileName, .BackupFileDir, .SampleCode _
            , .avgSteps, .doUp, .doBoth, .measurementSteps, .RockmagMode)
    End With
    'return the object created
    
    
    On Error GoTo 0
    Exit Function
Oops:
    Select Case Err.Number
    Case Else
        MsgBox "Error in SampleIndexRegistrations" & vbCrLf & Err.Number & ": " & Err.Description
    End Select
    Set objNewMember = Nothing

End Function


Public Property Get Item(vntIndexKey As Variant) As SampleIndexRegistration
Attribute Item.VB_UserMemId = 0
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
  Dim blankItem As SampleIndexRegistration
  On Error GoTo Oops
  If vntIndexKey = SampleHolderIndexTag Then
    Set Item = SampleHolderIndex
  Else
    Set Item = mCol(vntIndexKey)
  End If
  On Error GoTo 0
  Exit Sub
Oops:
  Select Case Err.Number  ' Evaluate error number.
    Case 5         ' invalid index key
        Set blankItem = New SampleIndexRegistration
        Set Item = blankItem
        Set blankItem = Nothing
    Case Else
        MsgBox "unknown error in sampleindexregistrations"
  End Select
  
End Property

Private Sub MakeSampleHolder()
    
    Set SampleHolderIndex = New SampleIndexRegistration
    With SampleHolderIndex
        .FileName = SampleHolderIndexTag
        .avgSteps = 1
        .doUp = True
        .doBoth = False
        Set .measurementSteps = New RockmagSteps
        Set .sampleSet = New Samples
        .measurementSteps.Add "NRM", MeasureSusceptibility:=True
        .sampleSet.IndexFile = SampleHolderIndexTag
        .sampleSet.Add "Holder"
    End With
        
End Sub


Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = mCol.Count
End Property


Public Sub Remove(vntIndexKey As Variant)
    'used when removing an element from the collection
    'vntIndexKey contains either the Index or Key, which is why
    'it is declared as a Variant
    'Syntax: x.Remove(xyz)


    mCol.Remove vntIndexKey
End Sub


Public Property Get NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    'this property allows you to enumerate
    'this collection with the For...Each syntax
    Set NewEnum = mCol.[_NewEnum]
End Property


Private Sub Class_Initialize()
    'creates the collection when this class is created
    Set mCol = New Collection
    
    MakeSampleHolder
End Sub


Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
    Set SampleHolderIndex = Nothing
End Sub

Public Sub Clear()
    Set mCol = Nothing
    Set mCol = New Collection
End Sub

Public Function IsValidFile(FileName As String)
    IsValidFile = False
    On Error GoTo fin
    IsValidFile = (LenB(Item(FileName).FileName) > 0)
fin:
    On Error GoTo 0
End Function

Public Function IsValidSample(FileName As String, Samplename As String)
    IsValidSample = False
    On Error GoTo fin
    IsValidSample = Item(FileName).sampleSet.IsValidSample(Samplename)
fin:
    On Error GoTo 0
End Function

Public Function Index(FileName As String) As Integer
    On Error GoTo fin
    Dim i As Integer
    Dim okay As Boolean
    okay = False
    For i = 1 To Count
        If Item(i).FileName = FileName Then
            okay = True
            Exit For
        End If
    Next i
    If Not okay Then Index = 0 Else Index = i
fin:
    On Error GoTo 0
End Function

Public Function sampleCount() As Integer
    Dim i As Integer
    Dim j As Integer

    sampleCount = 0
    If Count = 0 Then Exit Function
    For i = 1 To Count
        If Item(i).sampleSet.Count > 0 Then
            With Item(i).sampleSet
            For j = 1 To .Count
                sampleCount = sampleCount + 1
            Next j
            End With
        End If
    Next i
    
End Function

Public Function SampleByIndex(vindex As Integer) As Sample
    Dim sampCount As Integer
    Dim i As Integer
    
    sampCount = sampleCount
    On Error GoTo Oops
    If vindex < 1 Or vindex > sampCount Then GoTo Oops
    For i = 1 To Count
        With Item(i).sampleSet
        If vindex <= .Count Then Exit For Else vindex = vindex - .Count
        End With
    Next i
    Set SampleByIndex = Item(i).sampleSet.Item(vindex)
    On Error GoTo 0
    Exit Function
Oops:
    Set SampleByIndex = New Sample
End Function

Public Function SampleFileByIndex(vindex As Integer) As String
    Dim sampCount As Integer
    Dim i As Integer
    
    sampCount = sampleCount
    SampleFileByIndex = vbNullString
    If vindex < 1 Or vindex > sampCount Then Exit Function
    For i = 1 To Count
        With Item(i).sampleSet
        If vindex <= .Count Then Exit For Else vindex = vindex - .Count
        End With
    Next i
    SampleFileByIndex = Item(i).FileName
End Function
